<?php
/**
 * Auto-install migration: Smart Algo
 * Run this script to add use_smart_algo column
 * 
 * Access via: http://localhost/license-server/migrations/install_smart_algo.php
 */

require_once '../config.php';

header('Content-Type: text/html; charset=utf-8');

echo "<!DOCTYPE html><html><head><title>Migration: Smart Algo</title>";
echo "<style>body{font-family:Arial,sans-serif;max-width:600px;margin:50px auto;padding:20px;background:#f4f4f4;}";
echo ".box{background:white;padding:20px;border-radius:8px;box-shadow:0 2px 10px rgba(0,0,0,0.1);}";
echo ".success{color:#059669;background:#ecfdf5;padding:10px;border-radius:4px;margin:10px 0;}";
echo ".info{color:#3b82f6;background:#eff6ff;padding:10px;border-radius:4px;margin:10px 0;}";
echo "</style></head><body><div class='box'>";

echo "<h1>🧠 Migration: Smart Algorithm</h1>";

try {
    $results = [];
    
    // Check if columns already exist
    $columns = $pdo->query("SHOW COLUMNS FROM server_ads")->fetchAll(PDO::FETCH_COLUMN);
    
    // Add use_smart_algo column if not exists
    if (!in_array('use_smart_algo', $columns)) {
        $pdo->exec("ALTER TABLE server_ads ADD COLUMN use_smart_algo TINYINT(1) DEFAULT 0 COMMENT '1 = Use Smart Algo, 0 = Use Static Freq Cap'");
        $results[] = ['success', '✅ Colonne <code>use_smart_algo</code> ajoutée avec succès'];
    } else {
        $results[] = ['info', 'ℹ️ Colonne <code>use_smart_algo</code> existe déjà'];
    }
    
    // Display results
    foreach ($results as $r) {
        echo "<div class='{$r[0]}'>{$r[1]}</div>";
    }
    
    echo "<div class='success' style='margin-top:20px;'><strong>🎉 Migration terminée !</strong></div>";
    echo "<p><a href='../admin/advertising.php' style='color:#3b82f6;'>← Retour à la gestion des publicités</a></p>";
    
} catch (Exception $e) {
    echo "<div class='error'><strong>❌ Erreur:</strong> " . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "</div></body></html>";
