-- Ad Impression Control Migration
-- Run this SQL to add the new columns for impression limits and frequency capping

ALTER TABLE server_ads 
    ADD COLUMN IF NOT EXISTS max_views INT NULL DEFAULT NULL COMMENT 'NULL or 0 = unlimited',
    ADD COLUMN IF NOT EXISTS frequency_cap_hours INT DEFAULT 24 COMMENT 'Min hours between showing same ad to same IP, 0 = no limit';

-- Ensure server_ads_stats has viewed_at column for frequency capping
ALTER TABLE server_ads_stats 
    MODIFY COLUMN viewed_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;

-- Verify columns were added
DESCRIBE server_ads;
DESCRIBE server_ads_stats;
