<?php
/**
 * Admin - Modules Management - Clean Modern Design
 */
require_once '../config.php';
$admin = isAdminLogged();

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'update') {
        $code = $_POST['code'];
        $name = trim($_POST['name']);
        $price = floatval($_POST['price_monthly']);
        $isCore = isset($_POST['is_core']) ? 1 : 0;
        
        $stmt = $pdo->prepare("UPDATE modules SET name = ?, price_monthly = ?, is_core = ? WHERE code = ?");
        $stmt->execute([$name, $price, $isCore, $code]);
        $message = "Module mis à jour";
    }
    
    if ($action === 'create') {
        $code = strtolower(trim($_POST['code']));
        $name = trim($_POST['name']);
        $icon = trim($_POST['icon']);
        $category = $_POST['category'];
        $price = floatval($_POST['price_monthly']);
        
        $stmt = $pdo->prepare("INSERT INTO modules (code, name, icon, category, price_monthly) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$code, $name, $icon, $category, $price]);
        $message = "Module créé";
    }
}

$stmt = $pdo->query("SELECT * FROM modules ORDER BY sort_order ASC");
$modules = $stmt->fetchAll();
$currentPage = 'modules';
$pageTitle = 'Modules - License Server';
?>
<?php include 'includes/header.php'; ?>
    
    <!-- Sidebar -->
    <?php include 'includes/sidebar.php'; ?>

    <!-- Main Content -->
    <main class="ml-60 p-8">
        <div class="max-w-6xl mx-auto">
            
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h1 class="text-2xl font-bold text-slate-800">Modules</h1>
                    <p class="text-slate-500 text-sm">Catalogue des modules disponibles</p>
                </div>
                <button onclick="document.getElementById('createModal').classList.remove('hidden')" 
                    class="bg-indigo-600 text-white font-semibold px-4 py-2.5 rounded-lg flex items-center gap-2 hover:bg-indigo-700 active:scale-[0.98] transition-all text-sm">
                    <i class="fa-solid fa-plus"></i>
                    Nouveau Module
                </button>
            </div>

            <?php if ($message): ?>
                <div class="mb-4 p-3 bg-emerald-50 border border-emerald-200 rounded-lg text-emerald-700 text-sm flex items-center gap-2">
                    <i class="fa-solid fa-check-circle"></i><?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>

            <!-- Modules Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php foreach ($modules as $mod): ?>
                    <div class="bg-white rounded-xl p-5 border border-slate-200 shadow-sm hover:shadow-md transition-shadow">
                        <div class="flex items-start justify-between mb-3">
                            <div class="w-11 h-11 bg-indigo-50 rounded-xl flex items-center justify-center">
                                <i class="<?= htmlspecialchars($mod['icon']) ?> text-lg text-indigo-600"></i>
                            </div>
                            <?php if ($mod['is_core']): ?>
                                <span class="bg-emerald-100 text-emerald-700 text-xs font-semibold px-2 py-0.5 rounded-full">CORE</span>
                            <?php endif; ?>
                        </div>
                        <h3 class="text-slate-800 font-semibold mb-1"><?= htmlspecialchars($mod['name']) ?></h3>
                        <p class="text-slate-400 text-sm mb-3">
                            <code class="bg-slate-100 px-1.5 py-0.5 rounded text-xs"><?= htmlspecialchars($mod['code']) ?></code>
                        </p>
                        <div class="flex items-center justify-between">
                            <span class="text-slate-700 font-semibold text-sm">
                                <?= $mod['price_monthly'] > 0 ? number_format($mod['price_monthly'], 2) . '€/mois' : 'Gratuit' ?>
                            </span>
                            <span class="text-slate-400 text-xs uppercase"><?= htmlspecialchars($mod['category']) ?></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

        </div>
    </main>

    <!-- Create Modal -->
    <div id="createModal" class="hidden fixed inset-0 bg-black/40 flex items-center justify-center z-50">
        <div class="bg-white rounded-xl p-6 w-full max-w-md shadow-xl">
            <h2 class="text-lg font-bold text-slate-800 mb-5">Nouveau Module</h2>
            <form method="POST" class="space-y-4">
                <input type="hidden" name="action" value="create">
                <div class="grid grid-cols-2 gap-3">
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Code</label>
                        <input type="text" name="code" required class="w-full bg-slate-50 border border-slate-200 rounded-lg px-3 py-2.5 text-slate-800 focus:outline-none focus:border-indigo-500 text-sm" placeholder="module_code">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Catégorie</label>
                        <select name="category" class="w-full bg-slate-50 border border-slate-200 rounded-lg px-3 py-2.5 text-slate-800 focus:outline-none focus:border-indigo-500 text-sm">
                            <option value="core">Core</option>
                            <option value="hr">HR</option>
                            <option value="finance">Finance</option>
                            <option value="operations">Operations</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Nom</label>
                    <input type="text" name="name" required class="w-full bg-slate-50 border border-slate-200 rounded-lg px-3 py-2.5 text-slate-800 focus:outline-none focus:border-indigo-500 text-sm" placeholder="Nom du module">
                </div>
                <div class="grid grid-cols-2 gap-3">
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Icône (FA)</label>
                        <input type="text" name="icon" class="w-full bg-slate-50 border border-slate-200 rounded-lg px-3 py-2.5 text-slate-800 focus:outline-none focus:border-indigo-500 text-sm" placeholder="fa-solid fa-star">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Prix (€/mois)</label>
                        <input type="number" step="0.01" name="price_monthly" value="0" class="w-full bg-slate-50 border border-slate-200 rounded-lg px-3 py-2.5 text-slate-800 focus:outline-none focus:border-indigo-500 text-sm">
                    </div>
                </div>
                <div class="flex gap-3 pt-3">
                    <button type="button" onclick="document.getElementById('createModal').classList.add('hidden')" class="flex-1 py-2.5 border border-slate-200 text-slate-600 rounded-lg hover:bg-slate-50 font-medium text-sm transition-all">Annuler</button>
                    <button type="submit" class="flex-1 py-2.5 bg-indigo-600 text-white font-semibold rounded-lg hover:bg-indigo-700 text-sm transition-all">Créer</button>
                </div>
            </form>
        </div>
    </div>

</body>
</html>
