<?php
// Ensure $currentPage is set to avoid errors
if (!isset($currentPage)) $currentPage = '';
?>
<aside id="sidebar" class="fixed left-0 top-0 w-60 h-screen bg-white dark:bg-slate-900 border-r border-slate-200 dark:border-slate-700 p-5 flex flex-col z-50">
    <div class="flex items-center gap-3 mb-8 pb-5 border-b border-slate-100 dark:border-slate-700">
        <div class="w-9 h-9 bg-indigo-600 rounded-xl flex items-center justify-center">
            <i class="fa-solid fa-key text-white text-sm"></i>
        </div>
        <div>
            <h1 class="font-bold text-slate-800 dark:text-white text-sm">License Server</h1>
            <p class="text-xs text-slate-400 dark:text-slate-500">Administration</p>
        </div>
    </div>

    <nav class="flex-1 space-y-1 overflow-y-auto custom-scrollbar">
        <a href="index.php" class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm font-medium <?= $currentPage === 'dashboard' ? 'nav-active' : 'text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800' ?>">
            <i class="fa-solid fa-chart-pie w-4 text-center"></i>
            Dashboard
        </a>
        <a href="tenants.php" class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm font-medium <?= $currentPage === 'tenants' ? 'nav-active' : 'text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800' ?>">
            <i class="fa-solid fa-building w-4 text-center"></i>
            Clients
        </a>
        <a href="subscriptions.php" class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm font-medium <?= $currentPage === 'subscriptions' ? 'nav-active' : 'text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800' ?>">
            <i class="fa-solid fa-file-contract w-4 text-center"></i>
            Abonnements
        </a>
        <a href="plans.php" class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm font-medium <?= $currentPage === 'plans' ? 'nav-active' : 'text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800' ?>">
            <i class="fa-solid fa-tags w-4 text-center"></i>
            Plans
        </a>
        <a href="modules.php" class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm font-medium <?= $currentPage === 'modules' ? 'nav-active' : 'text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800' ?>">
            <i class="fa-solid fa-puzzle-piece w-4 text-center"></i>
            Modules
        </a>
        <a href="advertising.php" class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm font-medium <?= $currentPage === 'advertising' ? 'nav-active' : 'text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800' ?>">
            <i class="fa-solid fa-bullhorn w-4 text-center"></i>
            Publicité
        </a>
        <a href="telemetry.php" class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm font-medium <?= $currentPage === 'telemetry' ? 'nav-active' : 'text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800' ?>">
            <i class="fa-solid fa-chart-line w-4 text-center"></i>
            Télémétrie
        </a>
        <a href="simulator.php" class="flex items-center gap-3 px-3 py-2.5 rounded-lg text-sm font-medium <?= $currentPage === 'simulator' ? 'nav-active' : 'text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800' ?>">
            <i class="fa-solid fa-server w-4 text-center"></i>
            Simulateur
        </a>
    </nav>

    <div class="border-t border-slate-100 dark:border-slate-700 pt-4">
        <!-- Dark Mode Toggle Button -->
        <button id="darkModeToggle" type="button"
            class="w-full flex items-center justify-between px-3 py-2.5 rounded-lg text-sm font-medium text-slate-600 dark:text-slate-300 hover:bg-slate-50 dark:hover:bg-slate-800 mb-3 cursor-pointer">
            <span class="flex items-center gap-3">
                <i id="darkIcon" class="fa-solid fa-moon w-4 text-center"></i>
                <span id="darkLabel">Mode Sombre</span>
            </span>
            <div id="toggleSwitch" class="relative w-11 h-6 bg-slate-300 rounded-full">
                <div id="toggleDot" class="absolute top-1 left-1 w-4 h-4 bg-white rounded-full shadow-md transition-all duration-200"></div>
            </div>
        </button>

        <div class="flex items-center gap-3 mb-3">
            <div class="w-8 h-8 bg-indigo-100 dark:bg-indigo-900 rounded-full flex items-center justify-center text-indigo-600 dark:text-indigo-400">
                <i class="fa-solid fa-user text-xs"></i>
            </div>
            <div>
                <p class="text-slate-700 dark:text-white font-medium text-sm"><?= htmlspecialchars($admin['username'] ?? 'Admin') ?></p>
                <p class="text-slate-400 dark:text-slate-500 text-xs"><?= htmlspecialchars($admin['role'] ?? 'Super Admin') ?></p>
            </div>
        </div>
        <a href="logout.php" class="flex items-center gap-2 text-red-500 hover:text-red-600 text-sm font-medium">
            <i class="fa-solid fa-right-from-bracket text-xs"></i>
            Déconnexion
        </a>
    </div>
</aside>

<script>
(function() {
    // Elements
    const toggle = document.getElementById('darkModeToggle');
    const icon = document.getElementById('darkIcon');
    const label = document.getElementById('darkLabel');
    const switchBg = document.getElementById('toggleSwitch');
    const dot = document.getElementById('toggleDot');
    
    // Check current state and update UI
    function updateUI() {
        const isDark = document.documentElement.classList.contains('dark');
        
        if (isDark) {
            icon.className = 'fa-solid fa-sun w-4 text-center text-amber-400';
            label.textContent = 'Mode Clair';
            switchBg.className = 'relative w-11 h-6 bg-indigo-600 rounded-full';
            dot.className = 'absolute top-1 left-6 w-4 h-4 bg-white rounded-full shadow-md transition-all duration-200';
        } else {
            icon.className = 'fa-solid fa-moon w-4 text-center';
            label.textContent = 'Mode Sombre';
            switchBg.className = 'relative w-11 h-6 bg-slate-300 rounded-full';
            dot.className = 'absolute top-1 left-1 w-4 h-4 bg-white rounded-full shadow-md transition-all duration-200';
        }
    }
    
    // Toggle function
    function toggleDarkMode() {
        const html = document.documentElement;
        
        if (html.classList.contains('dark')) {
            html.classList.remove('dark');
            localStorage.setItem('darkMode', 'disabled');
        } else {
            html.classList.add('dark');
            localStorage.setItem('darkMode', 'enabled');
        }
        
        updateUI();
    }
    
    // Event listener
    if (toggle) {
        toggle.addEventListener('click', toggleDarkMode);
    }
    
    // Initialize UI on load
    updateUI();
})();
</script>
