<?php
// Ensure this file is included after config.php
if (!isset($pageTitle)) $pageTitle = 'Admin - License Server';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    
    <!-- Tailwind CSS with Dark Mode Config -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        // Configure Tailwind BEFORE any rendering
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    
    <!-- Apply dark mode immediately from localStorage to prevent flash -->
    <script>
        (function() {
            try {
                const darkMode = localStorage.getItem('darkMode');
                if (darkMode === 'enabled') {
                    document.documentElement.classList.add('dark');
                } else if (darkMode === 'disabled') {
                    document.documentElement.classList.remove('dark');
                } else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
                    document.documentElement.classList.add('dark');
                }
            } catch(e) {}
        })();
    </script>
    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <style>
        * { font-family: 'Inter', sans-serif; }
        .nav-active { background: #4f46e5; color: white; }
        
        /* ========================================
           GLOBAL DARK MODE OVERRIDES
           These apply automatically in dark mode
           ======================================== */
        
        /* Cards and containers */
        html.dark .bg-white { background-color: #1e293b !important; }
        html.dark .bg-slate-50 { background-color: #334155 !important; }
        html.dark .bg-slate-100 { background-color: #1e293b !important; }
        
        /* Text colors */
        html.dark .text-slate-800 { color: #f1f5f9 !important; }
        html.dark .text-slate-700 { color: #e2e8f0 !important; }
        html.dark .text-slate-600 { color: #cbd5e1 !important; }
        html.dark .text-slate-500 { color: #94a3b8 !important; }
        
        /* Borders */
        html.dark .border-slate-100 { border-color: #475569 !important; }
        html.dark .border-slate-200 { border-color: #475569 !important; }
        html.dark .border-slate-300 { border-color: #64748b !important; }
        
        /* Form inputs */
        html.dark input, 
        html.dark select, 
        html.dark textarea {
            background-color: #334155 !important;
            border-color: #475569 !important;
            color: #f1f5f9 !important;
        }
        html.dark input::placeholder,
        html.dark textarea::placeholder {
            color: #94a3b8 !important;
        }
        html.dark input:focus, 
        html.dark select:focus, 
        html.dark textarea:focus {
            border-color: #6366f1 !important;
            outline: none;
        }
        
        /* Tables */
        html.dark table { background-color: #1e293b !important; }
        html.dark th { background-color: #334155 !important; color: #f1f5f9 !important; }
        html.dark td { color: #e2e8f0 !important; }
        html.dark tr:hover { background-color: #334155 !important; }
        
        /* Modals */
        html.dark .modal-content,
        html.dark [class*="modal"] > div {
            background-color: #1e293b !important;
        }
        
        /* Badges and pills */
        html.dark .bg-emerald-50 { background-color: rgba(16, 185, 129, 0.2) !important; }
        html.dark .bg-amber-50 { background-color: rgba(245, 158, 11, 0.2) !important; }
        html.dark .bg-red-50 { background-color: rgba(239, 68, 68, 0.2) !important; }
        html.dark .bg-blue-50 { background-color: rgba(59, 130, 246, 0.2) !important; }
        html.dark .bg-indigo-50 { background-color: rgba(99, 102, 241, 0.2) !important; }
        html.dark .bg-purple-50 { background-color: rgba(139, 92, 246, 0.2) !important; }
        html.dark .bg-teal-50 { background-color: rgba(20, 184, 166, 0.2) !important; }
        html.dark .bg-cyan-50 { background-color: rgba(6, 182, 212, 0.2) !important; }
        html.dark .bg-rose-50 { background-color: rgba(244, 63, 94, 0.2) !important; }
        
        /* Icon backgrounds */
        html.dark .bg-emerald-100 { background-color: rgba(16, 185, 129, 0.3) !important; }
        html.dark .bg-amber-100 { background-color: rgba(245, 158, 11, 0.3) !important; }
        html.dark .bg-red-100 { background-color: rgba(239, 68, 68, 0.3) !important; }
        html.dark .bg-blue-100 { background-color: rgba(59, 130, 246, 0.3) !important; }
        html.dark .bg-indigo-100 { background-color: rgba(99, 102, 241, 0.3) !important; }
        html.dark .bg-purple-100 { background-color: rgba(139, 92, 246, 0.3) !important; }
        html.dark .bg-teal-100 { background-color: rgba(20, 184, 166, 0.3) !important; }
        html.dark .bg-cyan-100 { background-color: rgba(6, 182, 212, 0.3) !important; }
        html.dark .bg-rose-100 { background-color: rgba(244, 63, 94, 0.3) !important; }
        
        /* Hover states */
        html.dark .hover\:bg-slate-50:hover { background-color: #334155 !important; }
        html.dark .hover\:bg-slate-100:hover { background-color: #475569 !important; }
        
        /* Gradient border for special cards */
        .gradient-border {
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 50%, #d946ef 100%);
            padding: 2px;
            border-radius: 1rem;
        }
        .gradient-border > div { background: white; border-radius: calc(1rem - 2px); }
        html.dark .gradient-border > div { background: #1e293b; }
        
        /* Custom scrollbar */
        .custom-scrollbar::-webkit-scrollbar { width: 4px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 2px; }
        html.dark .custom-scrollbar::-webkit-scrollbar-thumb { background: #475569; }
        
        /* Pulse animation */
        @keyframes pulse-slow { 0%, 100% { opacity: 1; } 50% { opacity: 0.6; } }
        .pulse-slow { animation: pulse-slow 3s ease-in-out infinite; }
        
        /* Smooth transitions */
        * { transition: background-color 0.15s ease, border-color 0.15s ease, color 0.15s ease; }
    </style>
</head>
<body class="min-h-screen bg-slate-100 dark:bg-slate-900">
